/* Beispiel1116.java */ 

public class Beispiel1116
{
  public static double summe(DoubleMethod f, int von, int bis)
  {
    double ret = 0;
    for (int i = von; i <= bis; ++i) 
    {
      ret += f.compute(i);
    }
    return ret;
  }
  
  public static void main(String[] args)
  {
    DoubleMethod f;
    
    //Variante 1: Die Grundform
    f = (x) -> { return Math.sqrt(x); };
    System.out.println(summe(f, 1, 10));
    
    //Variante 2: Mit syntaktischen Vereinfachungen
    f = x -> Math.sqrt(x);
    System.out.println(summe(f, 1, 10));

    //Variante 3: Mit Methoden-Referenz
    f = Math::sqrt;
    System.out.println(summe(f, 1, 10));
  }
}