/* Beispiel1117.java */ 

import java.util.function.*;

class ModuloArithmetik
{
  private int mod;
  
  public ModuloArithmetik(int mod)
  {
    this.mod = mod;
  }
  
  public double summe(double x, double y)
  {
    return ((int)(x + y)) % mod;
  }  
}

public class Beispiel1117
{
  public static void printTable(int dimX, int dimY, DoubleBinaryOperator f)
  {
    for (int y = 1; y <= dimY; ++y) {
      for (int x = 1; x <= dimX; ++x) {
        System.out.print(f.applyAsDouble(x, y) + "/");
      }
      System.out.println();
    }
    System.out.println();
  }
  
  public static void main(String[] args)
  {
    //Potenzen
    printTable(3, 5, Math::pow);
    
    //Kleines Einmaleins
    printTable(10, 10, (x,y) -> x * y);
    
    //Modulo-5-Addition
    ModuloArithmetik ari5 = new ModuloArithmetik(5);
    printTable(6, 6, ari5::summe);
  }
}