/* Beispiel1405.java */

//------------------------------------------------------------------
//Abstrakte Produkte
//------------------------------------------------------------------
abstract class Product1
{
}

abstract class Product2
{
}

//------------------------------------------------------------------
//Abstrakte Factory
//------------------------------------------------------------------
abstract class ProductFactory
{
  public abstract Product1 createProduct1();

  public abstract Product2 createProduct2();

  public static ProductFactory getFactory(String variant)
  {
    ProductFactory ret = null;
    if (variant.equals("A")) {
      ret = new ConcreteFactoryVariantA();
    } else if (variant.equals("B")) {
      ret = new ConcreteFactoryVariantB();
    }
    return ret;
  }

  public static ProductFactory getDefaultFactory()
  {
    return getFactory("A");
  }
}

//------------------------------------------------------------------
//Konkrete Produkte fr Implementierungsvariante A
//------------------------------------------------------------------
class Product1VariantA
extends Product1
{
}

class Product2VariantA
extends Product2
{
}

//------------------------------------------------------------------
//Konkrete Factory fr Implementierungsvariante A
//------------------------------------------------------------------
class ConcreteFactoryVariantA
extends ProductFactory
{
  public Product1 createProduct1()
  {
    return new Product1VariantA();
  }

  public Product2 createProduct2()
  {
    return new Product2VariantA();
  }
}

//------------------------------------------------------------------
//Konkrete Produkte fr Implementierungsvariante B
//------------------------------------------------------------------
class Product1VariantB
extends Product1
{
}

class Product2VariantB
extends Product2
{
}

//------------------------------------------------------------------
//Konkrete Factory fr Implementierungsvariante B
//------------------------------------------------------------------
class ConcreteFactoryVariantB
extends ProductFactory
{
  public Product1 createProduct1()
  {
    return new Product1VariantB();
  }

  public Product2 createProduct2()
  {
    return new Product2VariantB();
  }
}

//------------------------------------------------------------------
//Beispielanwendung
//------------------------------------------------------------------
public class Beispiel1405
{
  public static void main(String[] args)
  {
    ProductFactory fact = ProductFactory.getDefaultFactory();
    Product1 prod1 = fact.createProduct1();
    Product2 prod2 = fact.createProduct2();
  }
}