/* Beispiel2101.java */

import java.io.*;

class ClassFileReader
{
  private RandomAccessFile f;

  public ClassFileReader(String name)
  throws IOException
  {
    if (!name.endsWith(".class")) {
      name += ".class";
    }
    f = new RandomAccessFile(name,"r");
  }

  public void close()
  {
    if (f != null) {
      try {
        f.close();
      } catch (IOException e) {
        //nichts
      }
    }
  }

  public void printSignature()
  throws IOException
  {
    String ret = "";
    int b;

    f.seek(0);
    for (int i=0; i<4; ++i) {
      b = f.read();
      ret += (char)(b/16+'A'-10);
      ret += (char)(b%16+'A'-10);
    }
    System.out.println(
      "Signatur...... "+
      ret
    );
  }

  public void printVersion()
  throws IOException
  {
    int minor, major;

    f.seek(4);
    minor = f.readShort();
    major = f.readShort();
    System.out.println(
      "Version....... "+
      major+"."+minor
    );
  }
}

public class Beispiel2101
{
  public static void main(String[] args)
  {
    ClassFileReader f;

    try {
      f = new ClassFileReader("Beispiel2101");
      f.printSignature();
      f.printVersion();
    } catch (IOException e) {
      System.out.println(e.toString());
    }
  }
}