/* Beispiel2208.java */

import java.io.IOException;
import java.net.URI;
import java.nio.file.*;

public class Beispiel2208
{
  public static void main(String[] args) throws IOException 
  {
    Path path = Paths.get(URI.create(
      "file:/C:/Program%20Files/Java/jre8/./readme.txt")); 

    System.err.println("##### path=" + path + " #####");
    System.err.println("path.getFileName() = " + 
      path.getFileName());

    System.err.println("path.getNameCount() = " + 
      path.getNameCount());
    System.err.println("path.getName(0) = " + 
      path.getName(0));
    
    System.err.println("path.getParent() = " + 
      path.getParent());
    System.err.println("path.getParent().getParent() = " + 
      path.getParent().getParent());
    System.err.println("path.getRoot() = " + path.getRoot());
    
    System.err.println("path.startsWith(\"C:/\") = " + 
      path.startsWith("C:/"));
    System.err.println("path.startsWith(\"c:/\") = " + 
      path.startsWith("c:/"));
    System.err.println("path.startsWith(\"C:\\\") = " + 
      path.startsWith("C:\\"));
    System.err.println("path.startsWith(\"c:\\\") = " + 
      path.startsWith("c:\\"));
    System.err.println("path.endsWith(\"readme.txt\") = " + 
      path.endsWith("readme.txt"));
    System.err.println("path.endsWith(\"README.TXT\") = " + 
      path.endsWith("README.TXT"));

    System.err.println("path.toAbsolutePath() = " + 
      path.toAbsolutePath());
    System.err.println("path.normalize() = " + 
      path.normalize());

    path =       Paths.get(URI.create(
      "file:/C:/Program%20Files/Java/jre8/."));
    Path other = Paths.get(
      URI.create("file:/C:/Program%20Files/Java/"));
    System.err.println("\n##### path =" + path + " #####");
    System.err.println("##### other=" + other + " #####");
    System.err.println("path.relativize(other) = " + 
      path.relativize(other)); 
    System.err.println("path.normalize().relativize(other) = " +
      path.normalize().relativize(other));

    System.err.println("path.toUri() = " + path.toUri());
    System.err.println("path.toFile() = " + path.toFile());
  }
}