/* Beispiel2212.java */
import java.net.URI;
import java.nio.file.*;
import java.util.List;

public class Beispiel2212
{
  public static void main(String[] args) throws Exception 
  {
    Path path = Paths.get(URI.create("file:/C:/users/test"));
    WatchService service = 
      FileSystems.getDefault().newWatchService();
    path.register(service,
      StandardWatchEventKinds.ENTRY_MODIFY,
      StandardWatchEventKinds.ENTRY_CREATE,
      StandardWatchEventKinds.ENTRY_DELETE);
    
    WatchKey key;
    do {
      key = service.take();
      List<WatchEvent<?>> events = key.pollEvents();
      if (events.size() > 0) {
        for (WatchEvent<?> e : events) {
          System.err.println(e.count() + " " + 
            e.kind() + " " + e.context());
        }
      }
    }
    while (key.reset());
  }
}