/* Beispiel2604.java */

import java.awt.*;

public class Beispiel2604
extends Frame
{
  public static void main(String[] args)
  {
    Beispiel2604 wnd = new Beispiel2604();
    wnd.setSize(300,200);
    wnd.setLocation(50,50);
    wnd.setVisible(true);
  }

  public Beispiel2604()
  {
    super();
    assignTitle();
    assignIcon();
    assignCursor();
    assignColors();
    assignFont();
    addWindowListener(new WindowClosingAdapter(true));
  }

  private void assignTitle()
  {
    setTitle("Vernderte Fensterelemente");
  }

  private void assignIcon()
  {
    Image img = getToolkit().getImage("testicon.gif");
    MediaTracker mt = new MediaTracker(this);

    mt.addImage(img, 0);
    try {
      //Warten, bis das Image vollstndig geladen ist,
      mt.waitForAll();
    } catch (InterruptedException e) {
      //nothing
    }
    setIconImage(img);
  }

  private void assignCursor()
  {
    setCursor(new Cursor(Cursor.WAIT_CURSOR));
  }

  private void assignColors()
  {
    setForeground(Color.white);
    setBackground(Color.black);
  }

  private void assignFont()
  {
    setFont(new Font("Serif", Font.PLAIN, 28));
  }

  public void paint(Graphics g)
  {
    g.drawString("Test in Vordergrundfarbe",10,70);
  }
}