/* Beispiel2708.java */

import java.awt.*;
import java.awt.event.*;

public class Beispiel2708
extends Frame
implements Runnable
{
  Image[] arImg;
  int actimage;

  public static void main(String[] args)
  {
    Beispiel2708 wnd = new Beispiel2708();
    wnd.setSize(200,150);
    wnd.setVisible(true);
    wnd.startAnimation();
  }

  public Beispiel2708()
  {
    super("Bitmap-Folge");
    addWindowListener(new WindowClosingAdapter(true));
  }

  public void startAnimation()
  {
    Thread th = new Thread(this);
    actimage = -1;
    th.start();
  }

  public void run()
  {
    //Bilder laden
    arImg = new Image[30];
    MediaTracker mt = new MediaTracker(this);
    Toolkit tk = getToolkit();
    for (int i = 1; i <= 30; ++i) {
      arImg[i-1] = tk.getImage("images/jana"+i+".gif");
      mt.addImage(arImg[i-1], 0);
      actimage = -i;
      repaint();
      try {
        mt.waitForAll();
      } catch (InterruptedException e) {
        //nothing
      }
    }
    //Animation beginnen
    actimage = 0;
    while (true) {
      repaint();
      actimage = (actimage + 1) % 30;
      try {
        Thread.sleep(50);
      } catch (InterruptedException e) {
        //nichts
      }
    }
  }

  public void paint(Graphics g)
  {
    if (actimage < 0) {
      g.drawString("Lade Bitmap "+(-actimage),10,50);
    } else {
      g.drawImage(arImg[actimage],10,30,this);
    }
  }
}