/* Beispiel2715.java */

import java.awt.*;

public class Beispiel2715
extends Frame
implements Runnable
{
  private int actx;
  private int dx;
  private int actarc1;
  private int actarc2;
  private Image dbImage;
  private Graphics dbGraphics;

  public static void main(String[] args)
  {
    Beispiel2715 frame = new Beispiel2715();
    frame.setSize(210,170);
    frame.setVisible(true);
    frame.startAnimation();
  }

  public Beispiel2715()
  {
    super("Ameisenanimation");
    addWindowListener(new WindowClosingAdapter(true));
  }

  public void startAnimation()
  {
    Thread th = new Thread(this);
    th.start();
  }

  public void run()
  {
    actx = 0;
    dx = 1;
    actarc1 = 0;
    actarc2 = 0;
    while (true) {
      repaint();
      actx += dx;
      if (actx < 0 || actx > 100) {
        dx = -dx;
        actx += 2*dx;
      }
      actarc1 = (actarc1 + 1) % 360;
      actarc2 = (actarc2 + 2) % 360;
      try {
        Thread.sleep(40);
      } catch (InterruptedException e) {
        //nichts
      }
    }
  }

  public void update(Graphics g)
  {
    //Double-Buffer initialisieren
    if (dbImage == null) {
      dbImage = createImage(
        this.getSize().width,
        this.getSize().height
      );
      dbGraphics = dbImage.getGraphics();
    }
    //Hintergrund lschen
    dbGraphics.setColor(getBackground());
    dbGraphics.fillRect(
      0,
      0,
      this.getSize().width,
      this.getSize().height
    );
    //Vordergrund zeichnen
    dbGraphics.setColor(getForeground());
    paint(dbGraphics);
    //Offscreen anzeigen
    g.drawImage(dbImage,0,0,this);
  }

  public void paint(Graphics g)
  {
    int xoffs = getInsets().left;
    int yoffs = getInsets().top;
    g.setColor(Color.lightGray);
    g.fillOval(xoffs+actx,yoffs+20,100,100);
    g.setColor(Color.red);
    g.drawArc(xoffs+actx,yoffs+20,100,100,actarc1,10);
    g.drawArc(xoffs+actx-1,yoffs+19,102,102,actarc1,10);
    g.setColor(Color.blue);
    g.drawArc(xoffs+actx,yoffs+20,100,100,360-actarc2,10);
    g.drawArc(xoffs+actx-1,yoffs+19,102,102,360-actarc2,10);
  }
}