/* Beispiel3005.java */

import java.awt.*;
import java.awt.event.*;

class MainMenu4
extends MenuBar
{
  private MenuItem miRueck;
  private CheckboxMenuItem miFarbe;

  private static void
  addNewMenuItem(Menu menu, String name, ActionListener listener)
  {
    int pos = name.indexOf('&');
    MenuShortcut shortcut = null;
    MenuItem mi;
    if (pos != -1) {
      if (pos < name.length() - 1) {
        char c = name.charAt(pos + 1);
        shortcut=new MenuShortcut(Character.toLowerCase(c));
        name=name.substring(0,pos)+name.substring(pos + 1);
      }
    }
    if (shortcut != null) {
      mi = new MenuItem(name, shortcut);
    } else {
      mi = new MenuItem(name);
    }
    mi.setActionCommand(name);
    mi.addActionListener(listener);
    menu.add(mi);
  }

  public MainMenu4(ActionListener listener)
  {
    Menu m;

    //Men "Gre"
    m = new Menu("Gre");
    addNewMenuItem(m, "&Grer", listener);
    addNewMenuItem(m, "&Kleiner", listener);
    m.addSeparator();
    addNewMenuItem(m, "B&eenden", listener);
    add(m);

    //Men "Position"
    m = new Menu("Position");
    addNewMenuItem(m, "&Links", listener);
    addNewMenuItem(m, "&Rechts", listener);
    addNewMenuItem(m, "&Oben", listener);
    addNewMenuItem(m, "&Unten", listener);
    add(m);
  }
}

public class Beispiel3005
extends Frame
implements ActionListener
{
  public static void main(String[] args)
  {
    Beispiel3005 wnd = new Beispiel3005();
  }

  public Beispiel3005()
  {
    super("Men-ActionEvents");
    setLocation(100,100);
    setSize(300,200);
    setMenuBar(new MainMenu4(this));
    setVisible(true);
    addWindowListener(new WindowClosingAdapter(true));
  }

  public void paint(Graphics g)
  {
    Insets   in = getInsets();
    Dimension d = getSize();
    g.setColor(Color.red);
    g.drawLine(
      in.left, in.top,
      d.width - in.right, d.height - in.bottom
    );
    g.drawLine(
      in.left, d.height - in.bottom,
      d.width - in.right, in.top
    );
  }

  public void actionPerformed(ActionEvent event)
  {
    String cmd = event.getActionCommand();
    if (cmd.equals("Grer")) {
      Dimension d = getSize();
      d.height *= 1.05;
      d.width  *= 1.05;
      setSize(d);
    } else if (cmd.equals("Kleiner")) {
      Dimension d = getSize();
      d.height *= 0.95;
      d.width  *= 0.95;
      setSize(d);
    } else if (cmd.equals("Beenden")) {
      setVisible(false);
      dispose();
      System.exit(0);
    } else if (cmd.equals("Links")) {
      setLocation(getLocation().x-10, getLocation().y);
    } else if (cmd.equals("Rechts")) {
      setLocation(getLocation().x+10, getLocation().y);
    } else if (cmd.equals("Oben")) {
      setLocation(getLocation().x, getLocation().y-10);
    } else if (cmd.equals("Unten")) {
      setLocation(getLocation().x, getLocation().y+10);
    }
  }
}