/* Beispiel3006.java */

import java.awt.*;
import java.awt.event.*;

class MyPopupMenu
extends PopupMenu
{
  public MyPopupMenu(ActionListener listener)
  {
    MenuItem mi;

    mi = new MenuItem("Rueckgaengig");
    mi.addActionListener(listener);
    add(mi);

    addSeparator();

    mi = new MenuItem("Ausschneiden");
    mi.addActionListener(listener);
    add(mi);

    mi = new MenuItem("Kopieren");
    mi.addActionListener(listener);
    add(mi);

    mi = new MenuItem("Einfuegen");
    mi.addActionListener(listener);
    add(mi);
  }
}

public class Beispiel3006
extends Frame
implements ActionListener
{
  MyPopupMenu popup;

  public static void main(String[] args)
  {
    Beispiel3006 wnd = new Beispiel3006();
  }

  public Beispiel3006()
  {
    super("Kontextmen");
    setLocation(100,100);
    setSize(300,200);
    setVisible(true);
    addWindowListener(new WindowClosingAdapter(true));
    //Kontextmen erzeugen und aktivieren
    popup = new MyPopupMenu(this);
    add(popup);
    enableEvents(AWTEvent.MOUSE_EVENT_MASK);
  }

  public void processMouseEvent(MouseEvent event)
  {
    if (event.isPopupTrigger()) {
      popup.show(
        event.getComponent(),
        event.getX(),
        event.getY()
      );
    }
    super.processMouseEvent(event);
  }

  public void actionPerformed(ActionEvent event)
  {
    System.out.println(event.getActionCommand());
  }
}