/* Beispiel3110.java */

import java.awt.*;
import java.awt.event.*;

class YesNoDialog
extends Dialog
implements ActionListener
{
  boolean result;

  public YesNoDialog(Frame owner, String msg)
  {
    super(owner, "Ja-/Nein-Auswahl", true);
    //Fenster
    setBackground(Color.lightGray);
    setLayout(new BorderLayout());
    setResizable(false); //Hinweis im Text beachten
    Point parloc = owner.getLocation();
    setLocation(parloc.x + 30, parloc.y + 30);
    //Message
    add(new Label(msg), BorderLayout.CENTER);
    //Buttons
    Panel panel = new Panel();
    panel.setLayout(new FlowLayout(FlowLayout.CENTER));
    Button button = new Button("Ja");
    button.addActionListener(this);
    panel.add(button);
    button = new Button("Nein");
    button.addActionListener(this);
    panel.add(button);
    add(panel, BorderLayout.SOUTH);
    pack();
  }

  public void actionPerformed(ActionEvent event)
  {
    result = event.getActionCommand().equals("Ja");
    setVisible(false);
    dispose();
  }

  public boolean getResult()
  {
    return result;
  }
}

public class Beispiel3110
extends Frame
implements ActionListener
{
  public static void main(String[] args)
  {
    Beispiel3110 wnd = new Beispiel3110();
    wnd.setVisible(true);
  }

  public Beispiel3110()
  {
    super("Modale Dialoge");
    setLayout(new FlowLayout());
    setBackground(Color.lightGray);
    Button button = new Button("Ende");
    button.addActionListener(this);
    add(button);
    setLocation(100,100);
    setSize(300,200);
    setVisible(true);
  }

  public void actionPerformed(ActionEvent event)
  {
    String cmd = event.getActionCommand();
    if (cmd.equals("Ende")) {
      YesNoDialog dlg;
      dlg = new YesNoDialog(
        this,
        "Wollen Sie das Programm wirklich beenden?"
      );
      dlg.setVisible(true);
      //Auf das Schlieen des Dialogs warten...
      if (dlg.getResult()) {
        setVisible(false);
        dispose();
        System.exit(0);
      }
    }
  }
}