/* Beispiel3302.java */

import java.awt.*;
import java.awt.event.*;

class MyDialog3302
extends Dialog
implements ActionListener
{
  public MyDialog3302(Frame parent)
  {
    super(parent,"MyDialog3302",true);
    setBounds(100,100,400,300);
    setBackground(Color.lightGray);
    setLayout(new BorderLayout());
    Panel panel = new Panel();
    customizeLayout(panel);
    add(panel, BorderLayout.CENTER);
    //Ende-Button
    Button button = new Button("Ende");
    button.addActionListener(this);
    add(button, BorderLayout.SOUTH);
    pack();
    //Window-Ereignisse
    addWindowListener(
      new WindowAdapter() {
        public void windowClosing(WindowEvent event)
        {
          endDialog();
        }
      }
    );
  }

  private void customizeLayout(Panel panel)
  {
    panel.setLayout(new FlowLayout());
    panel.add(new Segment7(0));
    panel.add(new Segment7(1));
    panel.add(new Segment7(2));
    panel.add(new Segment7(3));
    panel.add(new Segment7(4));
    panel.add(new Segment7(5));
    panel.add(new Segment7(6));
    panel.add(new Segment7(7));
    panel.add(new Segment7(8));
    panel.add(new Segment7(9));
  }

  public void actionPerformed(ActionEvent event)
  {
    String cmd = event.getActionCommand();
    if (cmd.equals("Ende")) {
      endDialog();
    }
  }

  void endDialog()
  {
    setVisible(false);
    dispose();
    ((Window)getParent()).toFront();
    getParent().requestFocusInWindow();
  }
}

public class Beispiel3302
extends Frame
implements ActionListener
{
  public static void main(String[] args)
  {
    Beispiel3302 wnd = new Beispiel3302();
    wnd.setSize(300,200);
    wnd.setVisible(true);
  }

  public Beispiel3302()
  {
    super("7-Segment-Anzeige");
    setBackground(Color.lightGray);
    setLayout(new FlowLayout());
    //Dialog-Button
    Button button = new Button("Dialog");
    button.addActionListener(this);
    add(button);
    //Ende-Button
    button = new Button("Ende");
    button.addActionListener(this);
    add(button);
    //Window-Ereignisse
    addWindowListener(new WindowClosingAdapter(true));
  }

  public void actionPerformed(ActionEvent event)
  {
    String cmd = event.getActionCommand();
    if (cmd.equals("Dialog")) {
      MyDialog3302 dlg = new MyDialog3302(this);
      dlg.setVisible(true);
    } else if (cmd.equals("Ende")) {
      setVisible(false);
      dispose();
      System.exit(0);
    }
  }
}