/* Beispiel3403.java */

import java.io.*;
import java.nio.file.*;

import javax.print.*;
import javax.print.attribute.*;
import javax.print.attribute.standard.Copies;

public class Beispiel3403
{
  public static void main(String[] args) throws IOException, PrintException
  {
    System.out.println("Gedruckt wird: " + args[0]);

    PrintService service = PrintServiceLookup.lookupDefaultPrintService();
    System.out.println("Standarddrucker ist: " + service.getName());
    
    Path path = Paths.get(args[0]);
    if (Files.notExists(path)) {
      throw new IllegalArgumentException(args[0] + " existiert nicht"); 
    }

    String mimetype = Files.probeContentType(path);
    System.err.println("MIME-Type: " + mimetype);
    
    DocFlavor flavor;
    switch (mimetype) {
      case "image/gif":
        flavor = DocFlavor.INPUT_STREAM.GIF;
        break;
      case "image/jpeg":
        flavor = DocFlavor.INPUT_STREAM.JPEG;
        break;
      default :
        throw new IllegalArgumentException(mimetype + " wird nicht untersttzt.");
    }
    System.err.println("Flavor: " + mimetype);
    
    InputStream stream = new FileInputStream(path.toFile());
    Doc document = new SimpleDoc(stream, flavor, null);
    
    if (!service.isDocFlavorSupported(flavor)) {
      throw new IllegalStateException(
        service.getName() + 
        " untersttzt " + flavor + " nicht"
      );
    }
    DocPrintJob job = service.createPrintJob();
    PrintRequestAttributeSet params = new HashPrintRequestAttributeSet();
    params.add(new Copies(1)); 
    
    job.print(document, params);
    stream.close();
  }
}