/* Beispiel3605.java */

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

class DesktopFrame
extends JFrame
{
  private JDesktopPane desk;

  public DesktopFrame()
  {
    super("DesktopFrame");
    this.desk = new JDesktopPane();
    desk.setDesktopManager(new DefaultDesktopManager());
    setContentPane(desk);
    addWindowListener(new WindowClosingAdapter(true));
  }

  public void addChild(JInternalFrame child, int x, int y)
  {
    child.setLocation(x, y);
    child.setSize(200, 150);
    child.setDefaultCloseOperation(
      JInternalFrame.DISPOSE_ON_CLOSE
    );
    desk.add(child);
    child.setVisible(true);
  }
}

class ChildFrame
extends JInternalFrame
{
  public ChildFrame(String title)
  {
    super("Child " + title, true, true);
    setIconifiable(true);
    setMaximizable(true);
    setBackground(Color.lightGray);
  }
}

public class Beispiel3605
{
  public static void main(String[] args)
  {
    //Desktop erzeugen
    DesktopFrame desktop = new DesktopFrame();
    desktop.setLocation(100, 100);
    desktop.setSize(400, 300);
    desktop.setVisible(true);
    //Zwei ChildFrames hinzufgen
    desktop.addChild(new ChildFrame("1"), 10, 10);
    desktop.addChild(new ChildFrame("2"), 20, 20);
  }
}