/* Beispiel3607.java */

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class Beispiel3607
extends JFrame
{
  public Beispiel3607()
  {
    super("Swing-Mentest II");
    addWindowListener(new WindowClosingAdapter(true));
    JMenuBar menubar = new JMenuBar();
    menubar.add(createExtrasMenu());
    setJMenuBar(menubar);
  }

  //---Private Methoden---------------
  private JMenu createExtrasMenu()
  {
    JMenu ret = new JMenu("Extras");
    ret.setMnemonic('X');
    JMenuItem mi;
    //Tools-Untermen
    ret.add(createToolsSubMenu());
    //Separator
    ret.addSeparator();
    //Statuszeile und Buttonleiste
    mi = new JCheckBoxMenuItem("Statuszeile");
    mi.setMnemonic('z');
    ((JCheckBoxMenuItem)mi).setState(true);
    ret.add(mi);
    mi = new JCheckBoxMenuItem("Buttonleiste");
    mi.setMnemonic('B');
    ret.add(mi);
    //Separator
    ret.addSeparator();
    //Offline, Verbinden, Anmelden
    ButtonGroup bg = new ButtonGroup();
    mi = new JRadioButtonMenuItem("Offline", true);
    mi.setMnemonic('O');
    ret.add(mi);
    bg.add(mi);
    mi = new JRadioButtonMenuItem("Verbinden");
    mi.setMnemonic('V');
    ret.add(mi);
    bg.add(mi);
    mi = new JRadioButtonMenuItem("Anmelden");
    mi.setMnemonic('A');
    ret.add(mi);
    bg.add(mi);
    //Separator
    ret.addSeparator();
    //Sicherheit
    mi = new JMenuItem(
      "Sicherheit",
      new ImageIcon("lock.gif")
    );
    mi.setMnemonic('S');
    mi.setHorizontalTextPosition(JMenuItem.LEFT);
    ret.add(mi);
    return ret;
  }

  private JMenu createToolsSubMenu()
  {
    JMenu ret = new JMenu("Tools");
    ret.setMnemonic('T');
    ret.add(new JMenuItem("Rechner", 'R'));
    ret.add(new JMenuItem("Editor",  'E'));
    ret.add(new JMenuItem("Browser", 'B'));
    ret.add(new JMenuItem("Zipper",  'Z'));
    ret.add(new JMenuItem("Snapper", 'S'));
    ret.add(new JMenuItem("Viewer",  'V'));
    return ret;
  }

  public static void main(String[] args)
  {
    Beispiel3607 frame = new Beispiel3607();
    frame.setLocation(100, 100);
    frame.setSize(300, 200);
    frame.setVisible(true);
  }
}