/* Beispiel3608.java */

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;

public class Beispiel3608
extends JFrame
implements MouseListener, ActionListener
{
  public Beispiel3608()
  {
    super("Kontextmens");
    addWindowListener(new WindowClosingAdapter(true));
    addMouseListener(this);
  }

  //MouseListener
  public void mouseClicked(MouseEvent event)
  {
    checkPopupMenu(event);
  }

  public void mouseEntered(MouseEvent event)
  {
  }

  public void mouseExited(MouseEvent event)
  {
  }

  public void mousePressed(MouseEvent event)
  {
    checkPopupMenu(event);
  }

  public void mouseReleased(MouseEvent event)
  {
    checkPopupMenu(event);
  }

  private void checkPopupMenu(MouseEvent event)
  {
    if (event.isPopupTrigger()) {
      JPopupMenu popup = new JPopupMenu();
      //Rckgngig hinzufgen
      JMenuItem mi = new JMenuItem("Rueckgaengig");
      mi.addActionListener(this);
      popup.add(mi);
      //Separator hinzufgen
      popup.addSeparator();
      //Ausschneiden, Kopieren, Einfgen hinzufgen
      mi = new JMenuItem("Ausschneiden");
      mi.addActionListener(this);
      popup.add(mi);
      mi = new JMenuItem("Kopieren");
      mi.addActionListener(this);
      popup.add(mi);
      mi = new JMenuItem("Einfuegen");
      mi.addActionListener(this);
      popup.add(mi);
      //Men anzeigen
      popup.show(
        event.getComponent(),
        event.getX(),
        event.getY()
      );
    }
  }

  //ActionListener
  public void actionPerformed(ActionEvent event)
  {
    System.out.println(event.getActionCommand());
  }

  public static void main(String[] args)
  {
    Beispiel3608 frame = new Beispiel3608();
    frame.setLocation(100, 100);
    frame.setSize(300, 200);
    frame.setVisible(true);
  }
}