/* Beispiel3610.java */

import java.awt.*;
import javax.swing.*;

public class Beispiel3610
extends JFrame
{
  public Beispiel3610()
  {
    super("Transparenz");
    addWindowListener(new WindowClosingAdapter(true));
    Container cp = getContentPane();
    //SimpleGridComponent erzeugen
    SimpleGridComponent grid = new SimpleGridComponent();
    grid.setLayout(new FlowLayout(FlowLayout.CENTER));
    //Transparenten Button hinzufgen
    JButton button = new JButton("Transparent");
    button.setOpaque(false);
    grid.add(button);
    //Undurchsichtigen Button hinzufgen
    button = new JButton("Opaque");
    grid.add(button);
    //SimpleGridComponent hinzufgen
    cp.add(grid, BorderLayout.CENTER);
  }

  public static void main(String[] args)
  {
    try {
      String plaf = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
      UIManager.setLookAndFeel(plaf);
      Beispiel3610 frame = new Beispiel3610();
      frame.setLocation(100, 100);
      frame.setSize(300, 100);
      frame.setVisible(true);
    } catch (Exception e) {
      e.printStackTrace();
      System.exit(1);
    }
  }
}

class SimpleGridComponent
extends JComponent
{
  protected void paintComponent(Graphics g)
  {
    int width = getSize().width;
    int height = getSize().height;
    g.setColor(Color.gray);
    for (int i = 0; i < width; i += 10) {
      g.drawLine(i, 0, i, height);
    }
    for (int i = 0; i < height; i += 10) {
      g.drawLine(0, i, width, i);
    }
  }
}