/* Beispiel3611.java */

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.util.List;
import javax.swing.*;

class ZufallFocusTraversalPolicy 
extends FocusTraversalPolicy
{
  private List<JButton> buttons;

  ZufallFocusTraversalPolicy(List<JButton> buttons)
  {
    this.buttons = new ArrayList<JButton>(buttons);
    mischen();
  }
  
  public Component getComponentAfter(Container con, Component com)
  {
    return buttons.get((buttons.indexOf(com)+1) % buttons.size());
  }

  public Component getComponentBefore(Container con, Component com)
  {
    int n = buttons.size();
    return buttons.get((buttons.indexOf(com) + n-1) % n);
  }
  
  public Component getFirstComponent(Container con)
  {
    return buttons.get(0);
  }
  
  public Component getLastComponent(Container con)
  {
    return buttons.get(buttons.size()-1);
  }
  
  public Component getDefaultComponent(Container con)
  {
    return getFirstComponent(con);
  }
  
  public void mischen()
  {
    Collections.shuffle(buttons);
    System.err.print("Fokusreihenfolge: ");
    for (JButton button : buttons) {
      System.err.print(button.getText() + " ");
    }
    System.err.println();
  }
}

public class Beispiel3611 
extends JFrame
{
  Beispiel3611()
  {
    setLayout(new FlowLayout());
    
    JPanel panel = new JPanel();
    List<JButton> buttons = new ArrayList<JButton>();
    for (int i = 1; i <= 4; i++) {
      JButton button = new JButton(Integer.toString(i));
      panel.add(button);
      buttons.add(button);
    }

    final ZufallFocusTraversalPolicy policy =  
    	new ZufallFocusTraversalPolicy(buttons);
    panel.setFocusCycleRoot(true);
    panel.setFocusTraversalPolicy(policy);     

    JButton mischen = new JButton("Mischen!");
    mischen.addActionListener(new ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        policy.mischen();
      }
    });
    
    add(panel);
    add(mischen);
    pack();
  }
  
  public static void main(String[] args)
  {
    Beispiel3611 frame = new Beispiel3611();
    frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    frame.setVisible(true);
  }
}