/* Beispiel3612.java */

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;

public class Beispiel3612
extends JFrame
implements ActionListener
{
  public Beispiel3612()
  {
    super("Invalidierung");
    addWindowListener(new WindowClosingAdapter(true));
    Container cp = getContentPane();
    ((JComponent)cp).setBorder(new EmptyBorder(5, 5, 5, 5));
    cp.setLayout(new FlowLayout());
    //Textfelder erzeugen
    JTextField tf1 = new JTextField("Zeile1", 20);
    JTextField tf2 = new JTextField("Zeile2", 20);
    JTextField tf3 = new JTextField("Zeile3", 20);
    //STRG+UMSCHALT+F6 auf Frame registrieren
    ((JComponent)cp).registerKeyboardAction(
      this,
      "dialog",
      ctrlShift(KeyEvent.VK_F6),
      JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT
    );
    //STRG+UMSCHALT+F7 auf tf1 registrieren
    tf1.registerKeyboardAction(
      this,
      "tf1",
      ctrlShift(KeyEvent.VK_F7),
      JComponent.WHEN_IN_FOCUSED_WINDOW
    );
    //STRG+UMSCHALT+F8 auf tf2 registrieren
    tf2.registerKeyboardAction(
      this,
      "tf2",
      ctrlShift(KeyEvent.VK_F8),
      JComponent.WHEN_FOCUSED
    );
    //Textfelder hinzufgen
    cp.add(tf1);
    cp.add(tf2);
    cp.add(tf3);
  }

  public void actionPerformed(ActionEvent event)
  {
    String cmd = event.getActionCommand();
    System.out.println(cmd);
  }

  private KeyStroke ctrlShift(int vkey)
  {
    return KeyStroke.getKeyStroke(
      vkey,
      Event.SHIFT_MASK + Event.CTRL_MASK
    );
  }

  public static void main(String[] args)
  {
    Beispiel3612 frame = new Beispiel3612();
    frame.setLocation(100, 100);
    frame.setSize(300, 200);
    frame.setVisible(true);
  }
}