/* Beispiel3701.java */

import java.awt.*;
import javax.swing.*;

public class Beispiel3701
extends JFrame
{
  public Beispiel3701()
  {
    super("JLabel");
    addWindowListener(new WindowClosingAdapter(true));
    Container cp = getContentPane();
    cp.setLayout(new GridLayout(5, 1));
    JLabel label;
    //Standardlabel
    label = new JLabel("Standard-Label");
    cp.add(label);
    //Label mit Icon
    label = new JLabel(
      "Label mit Icon",
      new ImageIcon("lock.gif"),
      JLabel.CENTER
    );
    cp.add(label);
    //Nur-Icon
    label = new JLabel(new ImageIcon("lock.gif"));
    cp.add(label);
    //Icon auf der rechten Seite
    label = new JLabel(
      "Label mit Icon rechts",
      new ImageIcon("lock.gif"),
      JLabel.CENTER
    );
    label.setHorizontalTextPosition(JLabel.LEFT);
    cp.add(label);
    //Label rechts unten
    label = new JLabel("Label rechts unten");
    label.setHorizontalAlignment(JLabel.RIGHT);
    label.setVerticalAlignment(JLabel.BOTTOM);
    cp.add(label);
  }

  public static void main(String[] args)
  {
    Beispiel3701 frame = new Beispiel3701();
    frame.setLocation(100, 100);
    frame.setSize(300, 200);
    frame.setVisible(true);
  }
}