/* Beispiel3702.java */

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

public class Beispiel3702
extends JFrame
implements ActionListener, CaretListener
{
  public Beispiel3702()
  {
    super("JTextField");
    addWindowListener(new WindowClosingAdapter(true));
    Container cp = getContentPane();
    cp.setLayout(new FlowLayout());
    JTextField tf;
    //Linksbndiges Textfeld mit "Hello, world"
    tf = new JTextField("Hello, world");
    cp.add(tf);
    //Leeres Textfeld mit 20 Spalten
    tf = new JTextField(20);
    cp.add(tf);
    //Textfeld mit "Hello, world" und 20 Spalten
    tf = new JTextField("Hello, world", 20);
    tf.addActionListener(this);
    tf.addCaretListener(this);
    cp.add(tf);
  }

  public void actionPerformed(ActionEvent event)
  {
    JTextField tf = (JTextField)event.getSource();
    System.out.println("---ActionEvent---");
    System.out.println(tf.getText());
    System.out.println(tf.getSelectedText());
    System.out.println(tf.getSelectionStart());
    System.out.println(tf.getSelectionEnd());
    System.out.println(tf.getCaretPosition());
  }

  public void caretUpdate(CaretEvent event)
  {
    System.out.println("---CaretEvent---");
    System.out.println(event.getDot());
    System.out.println(event.getMark());
  }

  public static void main(String[] args)
  {
    Beispiel3702 frame = new Beispiel3702();
    frame.setLocation(100, 100);
    frame.setSize(300, 150);
    frame.setVisible(true);
  }
}