/* Beispiel3709.java */

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class Beispiel3709
extends JFrame
implements ActionListener
{
  private ButtonGroup group = new ButtonGroup();

  public Beispiel3709()
  {
    super("JRadioButton");
    addWindowListener(new WindowClosingAdapter(true));
    //RadioButton-Panel
    JPanel panel = new JPanel();
    panel.setLayout(new GridLayout(3, 1));
    for (int i = 1; i <= 3; ++i) {
      JRadioButton rb = new JRadioButton("RadioButton" + i, i == 2);
      rb.setActionCommand(rb.getText());
      panel.add(rb);
      group.add(rb);
    }
    getContentPane().add(panel, BorderLayout.CENTER);
    //Selektion-Button
    JButton button = new JButton("Selektion");
    button.addActionListener(this);
    getContentPane().add(button, BorderLayout.SOUTH);
  }

  public void actionPerformed(ActionEvent event)
  {
    String cmd = event.getActionCommand();
    if (cmd.equals("Selektion")) {
      ButtonModel selected = group.getSelection();
      System.out.print("Selektiert: ");
      if (selected != null) {
        System.out.println(selected.getActionCommand());
      }
    }
  }

  public static void main(String[] args)
  {
    Beispiel3709 frame = new Beispiel3709();
    frame.setLocation(100, 100);
    frame.setSize(300, 120);
    frame.setVisible(true);
  }
}