/* Beispiel3713.java */

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;

public class Beispiel3713
extends JFrame
implements ChangeListener
{
  private JPanel coloredPanel;
  private JSlider slEast;
  private JSlider slSouth;
  private int     blue = 0;
  private int     red = 0;

  public Beispiel3713()
  {
    super("JSlider");
    addWindowListener(new WindowClosingAdapter(true));
    Container cp = getContentPane();
    //Vertikaler Schieberegler
    slEast = new JSlider(JSlider.VERTICAL, 0, 255, 0);
    slEast.setMajorTickSpacing(50);
    slEast.setMinorTickSpacing(10);
    slEast.setPaintTicks(true);
    slEast.setPaintLabels(true);
    slEast.addChangeListener(this);
    cp.add(slEast, BorderLayout.EAST);
    //Horizontaler Schieberegler
    slSouth = new JSlider(JSlider.HORIZONTAL, 0, 255, 0);
    slSouth.setMajorTickSpacing(100);
    slSouth.setMinorTickSpacing(25);
    slSouth.setPaintTicks(true);
    slSouth.setPaintLabels(true);
    slSouth.setSnapToTicks(true);
    slSouth.addChangeListener(this);
    cp.add(slSouth, BorderLayout.SOUTH);
    //Farbiges Panel
    coloredPanel = new JPanel();
    coloredPanel.setBackground(new Color(red, 0, blue));
    cp.add(coloredPanel, BorderLayout.CENTER);
  }

  public void stateChanged(ChangeEvent event)
  {
    JSlider sl = (JSlider)event.getSource();
    if (sl == slEast) {
      blue = sl.getValue();
    } else {
      red = sl.getValue();
    }
    coloredPanel.setBackground(new Color(red, 0, blue));
    if (!sl.getValueIsAdjusting()) {
      System.out.println("(" + red + ",0," + blue + ")");
    }
  }

  public static void main(String[] args)
  {
    Beispiel3713 frame = new Beispiel3713();
    frame.setLocation(100, 100);
    frame.setSize(300, 250);
    frame.setVisible(true);
  }
}