/* Beispiel3715.java */

import java.awt.*;
import java.awt.event.MouseEvent;
import java.util.*;
import java.util.List;

import javax.swing.*;
import javax.swing.plaf.LayerUI;

public class Beispiel3715 extends JFrame
{
  private final static int RADIUS = 10;
  private final List<Point> points = new ArrayList<Point>();
  
  public Beispiel3715()
  {
    super("JLayer");
    addWindowListener(new WindowClosingAdapter(true));
    
    LayerUI<JPanel> ui = new LayerUI<JPanel>()
    {
      public void paint(Graphics g, JComponent c) 
      {
        super.paint(g, c);
        g.setColor(Color.BLUE);
        for (Point p : points) {
          g.drawOval(p.x-RADIUS, p.y-RADIUS, 2*RADIUS, 2*RADIUS);
        }
      }
      
      protected void processMouseEvent(MouseEvent e, JLayer<? extends JPanel> l)
      {
        super.processMouseEvent(e, l);
        if (e.getID() == MouseEvent.MOUSE_CLICKED) {
          points.add(e.getPoint());
        }
        l.repaint();
      }
      
      public void installUI(JComponent c)
      {
        super.installUI(c);
        ((JLayer<?>) c).setLayerEventMask(AWTEvent.MOUSE_EVENT_MASK);
      }
      
      public void uninstallUI(JComponent c)
      {
        super.uninstallUI(c);
        ((JLayer<?>) c).setLayerEventMask(0);
      }
    };
    
    final JPanel panel = new JPanel(new FlowLayout());
    for (int i = 0; i < 20; i++) {
      JLabel label = new JLabel("Label "+ i);
      panel.add(label);
    }
    
    Container cp = getContentPane();
    cp.add(new JLayer<JPanel>(panel, ui), BorderLayout.CENTER);
  }
  
  public static void main(String[] args)
  {
    Beispiel3715 frame = new Beispiel3715();
    frame.setLocation(100, 100);
    frame.setSize(250, 200);
    frame.setVisible(true);
  }
}