/* Beispiel3802.java */

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class Beispiel3802
extends JFrame
{
  public Beispiel3802()
  {
    super("JSplitPane");
    addWindowListener(new WindowClosingAdapter(true));
    //Linkes Element erzeugen
    GridComponent grid1 = new GridComponent();
    grid1.setMinimumSize(new Dimension(50, 100));
    grid1.setPreferredSize(new Dimension(180, 100));
    //Rechtes Element erzeugen
    GridComponent grid2 = new GridComponent();
    grid2.setMinimumSize(new Dimension(100, 100));
    grid2.setPreferredSize(new Dimension(80, 100));
    //JSplitPane erzeugen
    JSplitPane sp = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT);
    sp.setLeftComponent(grid1);
    sp.setRightComponent(grid2);
    sp.setOneTouchExpandable(true);
    sp.setContinuousLayout(true);
    getContentPane().add(sp, BorderLayout.CENTER);
  }

  public static void main(String[] args)
  {
    Beispiel3802 frame = new Beispiel3802();
    frame.setLocation(100, 100);
    frame.setSize(300, 200);
    frame.setVisible(true);
  }
}

class GridComponent
extends JComponent
{
  public void paintComponent(Graphics g)
  {
    g.setColor(Color.gray);
    int width = getSize().width;
    int height = getSize().height;
    for (int i = 0; i < 10; ++i) {
      g.drawLine(i * width / 10, 0, i * width / 10, height);
    }
    for (int i = 0; i < 10; ++i) {
      g.drawLine(0, i * height / 10, width, i * height / 10);
    }
    g.setColor(Color.black);
    g.drawString("" + width, 5, 15);
  }
}