/* Beispiel3803.java */

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class Beispiel3803
extends JFrame
{
  JTabbedPane tp;

  public Beispiel3803()
  {
    super("JTabbedPane");
    addWindowListener(new WindowClosingAdapter(true));
    tp = new JTabbedPane();
    for (int i = 0; i < 5; ++i) {
      JPanel panel = new JPanel();
      panel.add(new JLabel("Karte " + i));
      JButton next = new JButton("Weiter");
      next.addActionListener(new NextTabActionListener());
      panel.add(next);
      tp.addTab("Tab" + i, panel);
    }
    getContentPane().add(tp, BorderLayout.CENTER);
  }

  class NextTabActionListener
  implements ActionListener
  {
    public void actionPerformed(ActionEvent event)
    {
      int tab = tp.getSelectedIndex();
      tab = (tab >= tp.getTabCount() - 1 ? 0 : tab + 1);
      tp.setSelectedIndex(tab);
      ((JPanel)tp.getSelectedComponent()).requestDefaultFocus();
    }
  }

  public static void main(String[] args)
  {
    Beispiel3803 frame = new Beispiel3803();
    frame.setLocation(100, 100);
    frame.setSize(300, 200);
    frame.setVisible(true);
  }
}