/* Beispiel3812.java */

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.tree.*;

public class Beispiel3812
extends JFrame
{
  public Beispiel3812()
  {
    super("JTree 2");
    addWindowListener(new WindowClosingAdapter(true));
    //Einfaches TreeModel bauen
    DefaultMutableTreeNode root, child, subchild;
    root = new DefaultMutableTreeNode("Root");
    for (int i = 1; i <= 5; ++i) {
      String name = "Child-" + i;
      child = new DefaultMutableTreeNode(name);
      root.add(child);
      for (int j = 1; j <= 3; ++j) {
        subchild = new DefaultMutableTreeNode(name + "-" + j);
        child.add(subchild);
      }
    }
    //JTree erzeugen und Einfachselektion aktivieren
    JTree tree = new JTree(root);
    TreeSelectionModel tsm = new DefaultTreeSelectionModel();
    tsm.setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);
    tree.setSelectionModel(tsm);
    tree.setRootVisible(true);
    //JTree einfgen
    Container cp = getContentPane();
    cp.add(new JScrollPane(tree), BorderLayout.CENTER);
    //TreeSelectionListener hinzufgen
    tree.addTreeSelectionListener(
      new TreeSelectionListener()
      {
        public void valueChanged(TreeSelectionEvent event)
        {
          TreePath tp = event.getNewLeadSelectionPath();
          if (tp != null) {
            System.out.println("  Selektiert: " + tp.toString());
          } else {
            System.out.println("  Kein Element selektiert");
          }
        }
      }
    );
  }

  public static void main(String[] args)
  {
    try {
      Beispiel3812 frame = new Beispiel3812();
      frame.setLocation(100, 100);
      frame.setSize(250, 200);
      frame.setVisible(true);
    } catch (Exception e) {
    }
  }
}