/* Beispiel3813.java */

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.tree.*;

public class Beispiel3813
extends JFrame
implements ActionListener
{
  protected DefaultMutableTreeNode root;
  protected DefaultTreeModel       treeModel;
  protected JTree                  tree;

  public Beispiel3813()
  {
    super("JTree 3");
    addWindowListener(new WindowClosingAdapter(true));
    //JTree erzeugen und Einfachselektion aktivieren
    root = new DefaultMutableTreeNode("Root");
    treeModel = new DefaultTreeModel(root);
    tree = new JTree(treeModel);
    TreeSelectionModel tsm = new DefaultTreeSelectionModel();
    tsm.setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);
    tree.setSelectionModel(tsm);
    tree.setRootVisible(true);
    //JTree einfgen
    Container cp = getContentPane();
    cp.add(new JScrollPane(tree), BorderLayout.CENTER);
    //ButtonPanel
    JPanel panel = new JPanel(new FlowLayout());
    String[] buttons = new String[]{"AddChild", "Delete", "Change"};
    for (int i = 0; i < buttons.length; ++i) {
      JButton button = new JButton(buttons[i]);
      button.addActionListener(this);
      panel.add(button);
    }
    cp.add(panel, BorderLayout.SOUTH);
  }

  public void actionPerformed(ActionEvent event)
  {
    String cmd = event.getActionCommand();
    TreePath tp = tree.getLeadSelectionPath(); 
    if (tp != null) {
      DefaultMutableTreeNode node;
      node = (DefaultMutableTreeNode)tp.getLastPathComponent();
      if (cmd.equals("AddChild")) {
        DefaultMutableTreeNode child;
        child = new DefaultMutableTreeNode("child");
        treeModel.insertNodeInto(child, node, node.getChildCount()); 
        TreeNode[] path = treeModel.getPathToRoot(node);
        tree.expandPath(new TreePath(path));
      } else if (cmd.equals("Delete")) {
        if (node != root) {
          TreeNode parent = node.getParent();
          TreeNode[] path = treeModel.getPathToRoot(parent);
          treeModel.removeNodeFromParent(node); 
          tree.setSelectionPath(new TreePath(path));
        }
      } else if (cmd.equals("Change")) {
        String name = node.toString();
        node.setUserObject(name + "C");
        treeModel.nodeChanged(node); 
      }
    }
  }

  public static void main(String[] args)
  {
    try {
      String plaf = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
      UIManager.setLookAndFeel(plaf);
      Beispiel3813 frame = new Beispiel3813();
      frame.setLocation(100, 100);
      frame.setSize(300, 300);
      frame.setVisible(true);
    } catch (Exception e) {
    }
  }
}