/* Beispiel3911.java */

class Counter3911
{
  int cnt;

  public Counter3911(int cnt)
  {
    this.cnt = cnt;
  }

  public int nextNumber()
  {
    int ret = cnt;
    //Hier erfolgen ein paar zeitaufwndige Berechnungen, um
    //so zu tun, als sei das Errechnen des Nachfolgezhlers
    //eine langwierige Operation, die leicht durch den
    //Scheduler unterbrochen werden kann.
    double x = 1.0, y, z;
    for (int i= 0; i < 1000000; ++i) {
      x = Math.sin((x*i%35)*1.13);
      y = Math.log(x+10.0);
      z = Math.sqrt(x+y);
    }
    //Jetzt ist der Wert gefunden
    cnt++;
    return ret;
  }
}

public class Beispiel3911
extends Thread
{
  private String name;
  private Counter3911 counter;

  public Beispiel3911(String name, Counter3911 counter)
  {
    this.name = name;
    this.counter = counter;
  }

  public static void main(String[] args)
  {
    Thread[] t = new Thread[5];
    Counter3911 cnt = new Counter3911(10);
    for (int i = 0; i < 5; ++i) {
      t[i] = new Beispiel3911("Thread-"+i,cnt);
      t[i].start();
    }
  }

  public void run()
  {
    while (true) {
      System.out.println(counter.nextNumber()+" for "+name);
    }
  }
}