/* Beispiel3913.java */

import java.util.*;

class Producer3913
extends Thread
{
  private Vector<String> v;

  public Producer3913(Vector<String> v)
  {
    this.v = v;
  }

  public void run()
  {
    String s;

    while (true) {
      synchronized (v) {
        s = "Wert "+Math.random();
        v.addElement(s);
        System.out.println("Produzent erzeugte "+s);
        v.notify();
      }
      try {
        Thread.sleep((int)(100*Math.random()));
      } catch (InterruptedException e) {
        //nichts
      }
    }
  }
}

class Consumer3913
extends Thread
{
   private Vector<String> v;

   public Consumer3913(Vector<String> v)
   {
      this.v = v;
   }

   public void run()
   {
      while (true) {
         synchronized (v) {
            if (v.size() < 1) {
               try {
                  v.wait();
               } catch (InterruptedException e) {
                  //nichts
               }
            }
            System.out.print(
              " Konsument fand "+ v.elementAt(0)
            );
            v.removeElementAt(0);
            System.out.println(" (verbleiben: "+v.size()+")");
         }
         try {
            Thread.sleep((int)(100*Math.random()));
         } catch (InterruptedException e) {
            //nichts
         }
      }
   }
}

public class Beispiel3913
{
   public static void main(String[] args)
   {
      Vector<String> v = new Vector<String>();

      Producer3913 p = new Producer3913(v);
      Consumer3913 c = new Consumer3913(v);
      p.start();
      c.start();
   }
}