/* Beispiel3914.java */

import java.util.concurrent.LinkedBlockingQueue;

class Producer3914 extends Thread
{
  private final LinkedBlockingQueue<String> v;

  public Producer3914(LinkedBlockingQueue<String> v)
  {
    this.v = v;
  }

  public void run()
  {
    String s;

    while (true) {
      s = "Wert " + Math.random();
      v.add(s);
      System.out.println("Produzent erzeugte " + s);
      try {
        Thread.sleep((int) (100 * Math.random()));
      }
      catch (InterruptedException x) {
        // nichts
      }
    }
  }
}

class Consumer3914 extends Thread
{
  private final LinkedBlockingQueue<String> v;

  public Consumer3914(LinkedBlockingQueue<String> v)
  {
    this.v = v;
  }

  public void run()
  {
    while (true) {
      try {
        String s = v.take();
        System.out.print(" Konsument fand " + s);
        System.out.println(" (verbleiben: " + v.size() + ")");
        Thread.sleep((int) (100 * Math.random()));
      }
      catch (InterruptedException e) {
        // nichts
      }
    }
  }
}

public class Beispiel3914
{
  public static void main(String[] args)
  {
    LinkedBlockingQueue<String> v = 
      new LinkedBlockingQueue<String>();

    Producer3914 p = new Producer3914(v);
    Consumer3914 c = new Consumer3914(v);
    p.start();
    c.start();
  }
}