/* Beispiel3915.java */

import java.io.*;

class Producer3915
extends Thread
{
  private PipedOutputStream pipe;

  public Producer3915(PipedOutputStream pipe)
  {
    this.pipe = pipe;
  }

  public void run()
  {
    while (true) {
      byte b = (byte)(Math.random() * 128);
      try {
        pipe.write(b);
        System.out.println("Produzent erzeugte " + b);
      } catch (IOException e) {
        System.err.println(e.toString());
      }
      try {
        Thread.sleep((int)(100*Math.random()));
      } catch (InterruptedException e) {
        //nichts
      }
    }
  }
}

class Consumer3915
extends Thread
{
  private PipedInputStream pipe;

  public Consumer3915(PipedInputStream pipe)
  {
    this.pipe = pipe;
  }

  public void run()
  {
    while (true) {
      try {
        byte b = (byte)pipe.read();
        System.out.println(" Konsument fand " + b);
      } catch (IOException e) {
        System.err.println(e.toString());
      }
      try {
        Thread.sleep((int)(100*Math.random()));
      } catch (InterruptedException e) {
        //nichts
      }
    }
  }
}

public class Beispiel3915
{
  public static void main(String[] args)
  throws Exception
  {
    PipedInputStream inPipe = new PipedInputStream();
    PipedOutputStream outPipe = new PipedOutputStream(inPipe);
    Producer3915 p = new Producer3915(outPipe);
    Consumer3915 c = new Consumer3915(inPipe);
    p.start();
    c.start();
  }
}