/* Beispiel3916.java */

import java.util.*;
import java.util.concurrent.*;

class PrimzahlBestimmer 
implements Callable<Boolean>
{
  private int n;

  PrimzahlBestimmer(int n) 
  {
    this.n = n;
  }

  public Boolean call() throws Exception 
  {
    for (int i = 2; i <= n / 2; i++) {
      if (n % i == 0) {
        return false;
      }
    }
    return true;
  }
}

public class Beispiel3916
{
  public static void main(String[] args) throws Exception 
  {
    //Threadpool und Ergebnismenge anlegen
    ExecutorService pool = Executors.newFixedThreadPool(3);
    List<Future<Boolean>> ergebnisse = new ArrayList<>(99);
    
    //Auftrge anlegen und einstellen
    for (int i = 1; i < 100; i++) {
      Callable<Boolean> auftrag = new PrimzahlBestimmer(i);
      Future<Boolean> ergebnis = pool.submit(auftrag);
      ergebnisse.add(ergebnis);
    }

    //Ergebnisse abfragen und ausgeben
    for (int i = 1; i < 100; i++) {
      if (ergebnisse.get(i-1).get()) {
        System.out.println(i);
      }
    }
    
    //Pool auflsen
    pool.shutdown();
  }  
}