/* Beispiel3917.java */
import java.io.*;
import java.net.URL;
import java.util.*;
import java.util.concurrent.*;

public class Beispiel3917
{
  private ForkJoinPool    pool   = new ForkJoinPool();
  private List<String> zeilen = new ArrayList<>();
  
  private class Arbeiter extends RecursiveTask<Boolean> 
  {
    private int von, bis;
    private String gesucht;
    
    public Arbeiter(String gesucht, int von, int bis) 
    {
      this.von = von;
      this.bis = bis;
      this.gesucht = gesucht;
    }
    
    protected Boolean compute() 
    {
      if (bis - von == 1) {
        //Problem hat Minimalgre erreicht: eine Zeile
        if (zeilen.get(von).indexOf(gesucht) >= 0) {
          return true;
        }
        return false;
      } else {
        //Verbleibende Zeilen werden halbiert:
        int mitte = von + (bis - von) / 2;
        Arbeiter w1, w2;
        w1 = new Arbeiter(gesucht, von, mitte);
        w2 = new Arbeiter(gesucht, mitte, bis);
        w1.fork();
        return w2.compute() ||  w1.join();
      }
    }
  }

  public void liesAusUrl(URL url) throws IOException 
  {
    BufferedReader reader = new BufferedReader(
      new InputStreamReader(url.openStream()));
    String line;
    
    while ((line = reader.readLine()) != null) {
      zeilen.add(line);
    }
    System.err.println(zeilen.size() + " Zeilen gelesen.");
  }
  
  public boolean suche(String gesucht) 
  {
    return pool.invoke(new Arbeiter(gesucht, 0, zeilen.size()));
  }
  
  public static void main(String[] args) throws Exception 
  {
    Beispiel3917 h = new Beispiel3917();
    h.liesAusUrl(new URL("file:grossedatei.txt")); 
    System.err.println(h.suche("Fork"));
  }
}