/* Beispiel3918.java */
import java.util.*;
import java.util.concurrent.*;

class SummeSequentiell
extends RecursiveTask<Long> 
{
  private long von, bis;
  
  SummeSequentiell(long von, long bis)
  {
    this.von = von;
    this.bis = bis;
  }
  
  protected Long compute() 
  {
    long summe = 0;
    for (long i = von; i <= bis; ++i) 
    {
      summe += i;
    }
    return summe;
  }
}

class SummeParallel
extends RecursiveTask<Long> 
{
  private long von, bis;
  
  SummeParallel(long von, long bis)
  {
    this.von = von;
    this.bis = bis;
  }
  
  protected Long compute() 
  {
    if ((bis - von) <= 10000000) {
      long summe = 0;
      for (long i = von; i <= bis; ++i) 
      {
        summe += i;
      }
      return summe;
    }
    long mitte = (von + bis) / 2;
    SummeParallel linkeSumme  = new SummeParallel(von, mitte);
    SummeParallel rechteSumme = new SummeParallel(mitte + 1, bis);
    rechteSumme.fork();
    return linkeSumme.compute() + rechteSumme.join();
  }
}

public class Beispiel3918
{
  public static void main(String[] args)
  {
    ForkJoinPool pool = new ForkJoinPool();
    //---Sequentielle Variante---
    //SummeSequentiell sum = new SummeSequentiell(1, 2000000000);
    //---Parallele Variante---
    SummeParallel sum = new SummeParallel(1, 2000000000);
    //---
    Long result = pool.invoke(sum);
    System.out.println(result);
  }  
}