/* Beispiel4008.java */

import java.io.*;
import java.util.*;

public class Beispiel4008
{
  public static void main(String[] args)
  {
    //Erzeugen der Familie
    Person opa = new Person("Eugen"); 
    Person oma = new Person("Therese");
    Person vater = new Person("Barny");
    Person mutter = new Person("Wilma");
    Person kind1 = new Person("Fritzchen");
    Person kind2 = new Person("Kalli");
    vater.father = opa;
    vater.mother = oma;
    kind1.father = kind2.father = vater;
    kind1.mother = kind2.mother = mutter; 

    //Serialisieren der Familie
    try {
      FileOutputStream fs = new FileOutputStream("test3.ser");
      ObjectOutputStream os = new ObjectOutputStream(fs);
      os.writeObject(kind1);
      os.writeObject(kind2);
      os.close();
    } catch (IOException e) {
      System.err.println(e.toString());
    }

    //Rekonstruieren der Familie
    kind1 = kind2 = null; 
    try {
      FileInputStream fs = new FileInputStream("test3.ser");
      ObjectInputStream is = new ObjectInputStream(fs);
      kind1 = (Person)is.readObject();
      kind2 = (Person)is.readObject();
      //berprfen der Objekte
      System.out.println(kind1.name); 
      System.out.println(kind2.name);
      System.out.println(kind1.father.name);
      System.out.println(kind1.mother.name);
      System.out.println(kind2.father.name);
      System.out.println(kind2.mother.name);
      System.out.println(kind1.father.father.name);
      System.out.println(kind1.father.mother.name); 
      //Name des Vaters ndern
      kind1.father.name = "Fred"; 
      //Erneutes berprfen der Objekte
      System.out.println("---"); 
      System.out.println(kind1.name);
      System.out.println(kind2.name);
      System.out.println(kind1.father.name);
      System.out.println(kind1.mother.name);
      System.out.println(kind2.father.name);
      System.out.println(kind2.mother.name);
      System.out.println(kind1.father.father.name);
      System.out.println(kind1.father.mother.name); 
      is.close();
    } catch (ClassNotFoundException e) {
      System.err.println(e.toString());
    } catch (IOException e) {
      System.err.println(e.toString());
    }
  }
}