/* Beispiel4011.java */

import java.io.*;
import java.util.*;

public class Beispiel4011
{
  public static Object seriaClone(Object o)
  throws IOException, ClassNotFoundException
  {
    //Serialisieren des Objekts
    ByteArrayOutputStream out = new ByteArrayOutputStream();
    ObjectOutputStream os = new ObjectOutputStream(out);
    os.writeObject(o);
    os.flush();
    //Deserialisieren des Objekts
    ByteArrayInputStream in = new ByteArrayInputStream(
      out.toByteArray()
    );
    ObjectInputStream is = new ObjectInputStream(in);
    Object ret = is.readObject();
    is.close();
    os.close();
    return ret;
  }

  public static void main(String[] args)
  {
    try {
      //Erzeugen des Buchobjekts
      Book book = new Book();
      book.author = "Peitgen, Heinz-Otto";
      String[] s = {"Jrgens, Hartmut", "Saupe, Dietmar"};
      book.coAuthors = s;
      book.title = "Bausteine des Chaos";
      book.publisher = "rororo science";
      book.pubyear = 1998;
      book.pages = 514;
      book.isbn = "3-499-60250-4";
      book.reflist = new Vector<String>();
      book.reflist.addElement("The World of MC Escher");
      book.reflist.addElement(
        "Die fraktale Geometrie der Natur"
      );
      book.reflist.addElement("Gdel, Escher, Bach");
      System.out.println(book.toString());
      //Erzeugen und Verndern der Kopie
      Book copy = (Book)seriaClone(book);
      copy.title += " - Fraktale";
      copy.reflist.addElement("Fractal Creations");
      //Ausgeben von Original und Kopie
      System.out.print(book.toString());
      System.out.println("---");
      System.out.print(copy.toString());
    } catch (IOException e) {
      System.err.println(e.toString());
    } catch (ClassNotFoundException e) {
      System.err.println(e.toString());
    }
  }
}

class Book
implements Serializable
{
  public String author;
  public String[] coAuthors;
  public String title;
  public String publisher;
  public int    pubyear;
  public int    pages;
  public String isbn;
  public Vector<String> reflist;

  public String toString()
  {
    String NL = System.getProperty("line.separator");
    StringBuffer ret = new StringBuffer(200);
    ret.append(author + NL);
    for (int i = 0; i < coAuthors.length; ++i) {
      ret.append(coAuthors[i] + NL);
    }
    ret.append("\"" + title + "\"" + NL);
    ret.append(publisher + " " + pubyear + NL);
    ret.append(pages + " pages" + NL);
    ret.append(isbn + NL);
    Enumeration<String> e = reflist.elements();
    while (e.hasMoreElements()) {
      ret.append("  " + e.nextElement() + NL);
    }
    return ret.toString();
  }
}