/* Beispiel4221.java */

import java.awt.*;
import java.io.IOException;

import javax.swing.*;
import javax.xml.parsers.*;

import org.w3c.dom.*;
import org.xml.sax.*;

public class Beispiel4221 extends JFrame
{
  private String title;
  private Color fgcolor;
  private Color bgcolor;
  private Font font;

  public Beispiel4221()
  {
    readConfig();

    setTitle(title);

    addWindowListener(new WindowClosingAdapter());
    JLabel label = new JLabel("Hello, World", JLabel.CENTER);
    label.setPreferredSize(new Dimension(200, 200));

    Container pane = getContentPane();
    pane.setLayout(new FlowLayout());
    pane.add(label);

    pane.setBackground(bgcolor);
    label.setForeground(fgcolor);
    label.setFont(font);

    pack();
  }

  private void readConfig()
  {
    try {
      DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
      factory.setValidating(true);
      DocumentBuilder builder = factory.newDocumentBuilder();
      builder.setEntityResolver(new EntityResolver()
      {
        public InputSource resolveEntity(String publicId, String systemId)
            throws SAXException, IOException
        {
          if (systemId.endsWith("config_jaxp.dtd"))
            return new InputSource(
              getClass().getResourceAsStream("config_jaxp.dtd"));
          return null;
        }
      });
      builder.setErrorHandler(new ErrorHandler()
      {
        public void warning(SAXParseException exception) throws SAXException
        {
        }
        public void fatalError(SAXParseException exception) throws SAXException
        {
          throw exception;
        }
        public void error(SAXParseException exception) throws SAXException
        {
          throw exception;
        }
      });
      Document document = builder.parse(getClass().getResourceAsStream(
          "config_jaxp.xml"));

      Element frameElement = document.getDocumentElement();
      Element titleElement = (Element) frameElement.getElementsByTagName(
          "title").item(0);
      title = titleElement.getTextContent().trim();

      Element fontElement = (Element) frameElement.getElementsByTagName("font")
          .item(0);
      font = new Font(fontElement.getTextContent().trim(), Font.PLAIN,
          Integer.parseInt(fontElement.getAttribute("size").trim()));

      Element fgcolorElement = (Element) frameElement.getElementsByTagName(
          "fgcolor").item(0);
      fgcolor = Color.decode(fgcolorElement.getTextContent().trim());

      Element bgcolorElement = (Element) frameElement.getElementsByTagName(
          "bgcolor").item(0);
      bgcolor = Color.decode(bgcolorElement.getTextContent().trim());
    }
    catch (ParserConfigurationException x) {
      x.printStackTrace();
    }
    catch (SAXException x) {
      x.printStackTrace();
    }
    catch (IOException x) {
      x.printStackTrace();
    }
  }

  public static void main(String[] args)
  {
    Beispiel4221 window = new Beispiel4221();
    window.setVisible(true);
  }
}