/* Beispiel4222.java */

import java.awt.*;
import java.io.IOException;

import javax.swing.*;
import javax.xml.parsers.*;

import org.xml.sax.*;
import org.xml.sax.helpers.DefaultHandler;

public class Beispiel4222 extends JFrame
{
  private String title;
  private Color fgcolor;
  private Color bgcolor;
  private Font font;

  public Beispiel4222()
  {
    readConfig();

    setTitle(title);

    addWindowListener(new WindowClosingAdapter());
    JLabel label = new JLabel("Hello, World", JLabel.CENTER);
    label.setPreferredSize(new Dimension(200, 200));

    Container pane = getContentPane();
    pane.setLayout(new FlowLayout());
    pane.add(label);

    pane.setBackground(bgcolor);
    label.setForeground(fgcolor);
    label.setFont(font);

    pack();
  }

  private void readConfig()
  {
    try {
      SAXParserFactory factory = SAXParserFactory.newInstance();
      factory.setValidating(true);
      SAXParser parser = factory.newSAXParser();

      parser.parse(getClass().getResourceAsStream("config_jaxp.xml"),
        new DefaultHandler()
        {
          private String element;

          private int fontsize;

          public void startElement(String uri, String localName,
              String qName, Attributes attributes) throws SAXException
          {
            element = qName;
            if (element.equals("font")) {
              fontsize = Integer.parseInt(attributes.getValue("size").trim());
            }
          }

          public void characters(char[] ch, int start, int length)
              throws SAXException
          {
            String text = String.valueOf(ch, start, length).trim();
            if (element.equals("title")) {
              title = text;
            }
            else if (element.equals("font")) {
              font = new Font(text, Font.PLAIN, fontsize);
            }
            else if (element.equals("fgcolor")) {
              fgcolor = Color.decode(text);
            }
            else if (element.equals("bgcolor")) {
              bgcolor = Color.decode(text);
            }
          }

          public InputSource resolveEntity(String publicId, String systemId)
              throws IOException, SAXException
          {
            if (systemId.endsWith("config_jaxp.dtd"))
              return new InputSource(getClass().getResourceAsStream(
                  "config_jaxp.dtd"));
            return null;
          }

          public void error(SAXParseException e) throws SAXException
          {
            throw e;
          }
        });
    }
    catch (ParserConfigurationException x) {
      x.printStackTrace();
    }
    catch (SAXException x) {
      x.printStackTrace();
    }
    catch (IOException x) {
      x.printStackTrace();
    }
  }

  public static void main(String[] args)
  {
    Beispiel4222 window = new Beispiel4222();
    window.setVisible(true);
  }
}