/* Beispiel4223.java */

import java.awt.*;

import javax.swing.*;
import javax.xml.stream.*;

public class Beispiel4223 extends JFrame
{
  private String title;
  private Color fgcolor;
  private Color bgcolor;
  private Font font;

  public Beispiel4223()
  {
    readConfig();

    setTitle(title);

    addWindowListener(new WindowClosingAdapter());
    JLabel label = new JLabel("Hello, World", JLabel.CENTER);
    label.setPreferredSize(new Dimension(200, 200));

    Container pane = getContentPane();
    pane.setLayout(new FlowLayout());
    pane.add(label);

    pane.setBackground(bgcolor);
    label.setForeground(fgcolor);
    label.setFont(font);

    pack();
  }

  private void readConfig()
  {
    try {
      XMLInputFactory factory = XMLInputFactory.newInstance();
      XMLStreamReader parser = factory.createXMLStreamReader(getClass()
          .getResourceAsStream("config_jaxp.xml"));

      while (parser.hasNext()) {
        if (parser.next() == XMLStreamConstants.START_ELEMENT) {
          if (parser.getLocalName().equals("titelzeile")) {
            this.title = parser.getElementText().trim();
          }
          if (parser.getLocalName().equals("font")) {
            int size = Integer.parseInt(parser.getAttributeValue(0).trim());
            font = new Font(parser.getElementText().trim(), Font.PLAIN, size);
          }
          if (parser.getLocalName().equals("fgcolor")) {
            fgcolor = Color.decode(parser.getElementText().trim());
          }
          if (parser.getLocalName().equals("bgcolor")) {
            bgcolor = Color.decode(parser.getElementText().trim());
          }
        }
      }
      parser.close();
    }
    catch (XMLStreamException x) {
      x.printStackTrace();
    }
  }

  public static void main(String[] args)
  {
    Beispiel4223 window = new Beispiel4223();
    window.setVisible(true);
  }
}