/* Beispiel4226.java */

import generated.Cframe;

import java.awt.*;

import javax.swing.*;
import javax.xml.bind.*;
import javax.xml.validation.*;

import org.xml.sax.SAXException;

public class Beispiel4226 extends JFrame
{
  private String title;
  private Color fgcolor;
  private Color bgcolor;
  private Font font;

  public Beispiel4226()
  {
    readConfig();

    setTitle(title);

    addWindowListener(new WindowClosingAdapter());
    JLabel label = new JLabel("Hello, World", JLabel.CENTER);
    label.setPreferredSize(new Dimension(200, 200));

    Container pane = getContentPane();
    pane.setLayout(new FlowLayout());
    pane.add(label);

    pane.setBackground(bgcolor);
    label.setForeground(fgcolor);
    label.setFont(font);

    pack();    
  }

  private void readConfig()
  {
    try {
      JAXBContext context = JAXBContext.newInstance("generated");
      Unmarshaller unmarshaller = context.createUnmarshaller();  

      SchemaFactory sf = SchemaFactory.newInstance(
         javax.xml.XMLConstants.W3C_XML_SCHEMA_NS_URI);

      Schema schema = sf.newSchema(getClass().getResource("config_jaxb.xsd"));
      unmarshaller.setSchema(schema);
      
      Cframe frame = (Cframe) unmarshaller.unmarshal(
        getClass().getResource("config_jaxb.xml"));
      this.title = frame.getCtitle();
      this.bgcolor = new Color(frame.getCbgcolor());
      this.fgcolor = new Color(frame.getCfgcolor());
      this.font = new Font(frame.getCfont().getValue(), Font.PLAIN, 
        frame.getCfont().getSize());
    }
    catch (JAXBException x) {
      x.printStackTrace();
    }
    catch (SAXException x) {
      x.printStackTrace();
    }
  }

  public static void main(String[] args)
  {
    Beispiel4226 window = new Beispiel4226();
    window.setVisible(true);
  }
}