/* Beispiel4405.java */

import java.net.*;
import java.io.*;

public class Beispiel4405
{
  public static void main(String[] args)
  {
    if (args.length != 2) {
      System.err.println(
        "Usage: java Beispiel4405 <host> <file>"
      );
      System.exit(1);
    }
    try {
      Socket sock = new Socket(args[0], 80);
      OutputStream out = sock.getOutputStream();
      InputStream in = sock.getInputStream();
      //GET-Kommando unter Verwendung des Host-Headers senden
      String s = "GET " + args[1] + " HTTP/1.1" + "\r\n";
      s += "Host: www.abc.de\r\n\r\n";
      out.write(s.getBytes());
      //Ausgabe lesen und anzeigen
      int len;
      byte[] b = new byte[4096];
      while ((len = in.read(b)) != -1) {
        System.out.write(b, 0, len);
      }
      //Programm beenden
      in.close();
      out.close();
      sock.close();
    } catch (IOException e) {
      System.err.println(e.toString());
      System.exit(1);
    }
  }
}