/* Beispiel4603.java */

import java.io.*;
import java.security.*;

public class Beispiel4603
{
  /**
   * Konvertiert ein Byte in einen Hex-String.
   */
  public static String toHexString(byte b)
  {
    int value = (b & 0x7F) + (b < 0 ? 128 : 0);
    String ret = (value < 16 ? "0" : "");
    ret += Integer.toHexString(value).toUpperCase();
    return ret;
  }

  public static void main(String[] args)
  {
    if (args.length < 2) {
      System.out.println(
        "Usage: java Beispiel4603 md-algorithm filename"
      );
      System.exit(0);
    }
    try {
      //MessageDigest erstellen
      MessageDigest md = MessageDigest.getInstance(args[0]);
      FileInputStream in = new FileInputStream(args[1]);
      int len;
      byte[] data = new byte[1024];
      while ((len = in.read(data)) > 0) {
        //MessageDigest updaten
        md.update(data, 0, len);
      }
      in.close();
      //MessageDigest berechnen und ausgeben
      byte[] result = md.digest();
      for (int i = 0; i < result.length; ++i) {
        System.out.print(toHexString(result[i]) + " ");
      }
      System.out.println();
    } catch (Exception e) {
      System.err.println(e.toString());
      System.exit(1);
    }
  }
}