/* CachedConnection.java */

import java.sql.*;
import java.util.*;

public class CachedConnection
{
  private Connection             con;
  private LinkedList<Statement>  cache;
  private int                    stmtcnt;

  public CachedConnection(Connection con)
  {
    this.con     = con;
    this.cache   = new LinkedList<Statement>();
    this.stmtcnt = 0;
  }

  public Statement getStatement()
  throws SQLException
  {
    if (cache.size() <= 0) {
      return con.createStatement();
    } else {
      return cache.poll();
    }
  }

  public void releaseStatement(Statement statement)
  {
    cache.add(statement);
  }
}