/* FilePrintHelper.java */

import java.util.*;

public class FilePrintHelper
{
  //---Membervariablen----------------------------------
  List<Entry> pageinfo;

  //---Konstruktor--------------------------------------
  public FilePrintHelper()
  {
    pageinfo = new ArrayList<Entry>();
  }

  //---Seitendefinition und -abfrage--------------------
  public void createPage(int page)
  {
    for (int i = pageinfo.size(); i <= page; ++i) {
      pageinfo.add(new Entry());
    }
  }

  public boolean knownPage(int page)
  {
    return page < pageinfo.size();
  }

  //---Verwaltung der Offsets---------------------------
  public long getFileOffset(int page)
  {
    Entry entry = pageinfo.get(page);
    return entry.fileoffset;
  }

  public void setFileOffset(int page, long fileoffset)
  {
    Entry entry = pageinfo.get(page);
    entry.fileoffset = fileoffset;
  }

  //---Lokale Klasse Entry------------------------------
  static class Entry
  {
    public long fileoffset;

    public Entry()
    {
      this.fileoffset = -1;
    }
  }
}