/* SaveURL.java */

import java.net.*;
import java.io.*;

public class SaveURL
{
  public static void main(String[] args)
  {
    if (args.length != 2) {
      System.err.println(
        "Usage: java SaveURL <url> <file>"
      );
      System.exit(1);
    }
    try {
      URL url = new URL(args[0]);
      OutputStream out = new FileOutputStream(args[1]);
      InputStream in = url.openStream();
      int len;
      byte[] b = new byte[100];
      while ((len = in.read(b)) != -1) {
        out.write(b, 0, len);
      }
      out.close();
      in.close();
    } catch (MalformedURLException e) {
      System.err.println(e.toString());
      System.exit(1);
    } catch (IOException e) {
      System.err.println(e.toString());
      System.exit(1);
    }
  }
}