/* SparseTableModel.java */

import java.util.*;
import javax.swing.table.*;

public class SparseTableModel
extends AbstractTableModel 
{
  private int size;
  private Hashtable<String, String> data;

  //Konstruktor
  public SparseTableModel(int size)
  {
    this.size = size;
    this.data = new Hashtable<String, String>();
  }

  //Methoden fr das TableModel-Interface
  public int getRowCount()
  {
    return size;
  }

  public int getColumnCount()
  {
    return size;
  }

  public String getColumnName(int columnIndex)
  {
    return "C" + columnIndex;
  }

  public Class<?> getColumnClass(int columnIndex)
  {
    return String.class;
  }

  public boolean isCellEditable(int rowIndex, int columnIndex)
  {
    return rowIndex < size && columnIndex < size;
  }

  public Object getValueAt(int rowIndex, int columnIndex)
  {
    String key = "[" + rowIndex + "," + columnIndex + "]";
    String value = data.get(key);
    return value == null ? "-" : value;
  }

  public void setValueAt(Object aValue, int rowIndex, int columnIndex)
  {
    String key = "[" + rowIndex + "," + columnIndex + "]";
    String value = (String)aValue;
    if (value.length() <= 0) {
      data.remove(key);
    } else {
      data.put(key, value);
    }
  }

  //Zustzliche Methoden
  public void printData()
  {
    Enumeration<String> e = data.keys();
    while (e.hasMoreElements()) {
      String key = e.nextElement();
      System.out.println(
        "At " + key + ": " + data.get(key)
      );
    }
  }
}