/* Test.java */

import java.lang.reflect.*;

public class Test
{
  public static Object createTestObject(String name)
  {
    //Klassennamen zusammenbauen
    int pos = name.lastIndexOf('.');
    if (pos == -1) {
      name = "Test" + name;
    } else {
      name = name.substring(0, pos + 1) + "Test" +
             name.substring(pos + 1);
    }
    //Klasse laden
    Object ret = null;
    try {
      Class<?> testclass = Class.forName(name);
      //Testobjekt instanzieren
      System.out.println("==============================");
      System.out.println("Instanzieren von: " + name);
      System.out.println("--");
      ret = testclass.newInstance();
    } catch (ClassNotFoundException e) {
      System.err.println("Kann Klasse nicht laden: " + name);
    } catch (InstantiationException e) {
      System.err.println("Fehler beim Instanzieren: " + name);
    } catch (IllegalAccessException e) {
      System.err.println("Unerlaubter Zugriff auf: " + name);
    }
    return ret;
  }

  public static void runTests(Object tester)
  {
    Class<?> clazz = tester.getClass();
    Method[] methods = clazz.getMethods();
    int cnt = 0;
    for (int i = 0; i < methods.length; ++i) {
      //Methodenname muss mit "test" anfangen
      String name = methods[i].getName();
      if (!name.startsWith("test")) {
        continue;
      }
      //Methode muss parameterlos sein
      Class<?>[] paras = methods[i].getParameterTypes();
      if (paras.length > 0) {
        continue;
      }
      //Methode darf nicht static sein
      int modifiers = methods[i].getModifiers();
      if (Modifier.isStatic(modifiers)) {
        continue;
      }
      //Nun kann die Methode aufgerufen werden
      ++cnt;
      System.out.println("==============================");
      System.out.println("Aufgerufen wird: " + name);
      System.out.println("--");
      try {
        methods[i].invoke(tester, new Object[0]);
      } catch (Exception e) {
        System.err.println(e.toString());
      }
    }
    if (cnt <= 0) {
      System.out.println("Keine Testmethoden gefunden");
    }
  }

  public static void main(String[] args)
  {
    if (args.length <= 0) {
      System.err.println("Aufruf: java Test <KlassenName>");
      System.exit(1);
    }
    Object tester = createTestObject(args[0]);
    runTests(tester);
  }
}