/* TimeServiceClient.java */

import java.rmi.*;

public class TimeServiceClient
{
  public static void main(String[] args)
  {
    try {
      String host = "ph01";
      String port = "1099";
      String srv  = "TimeService";
      String url = "rmi://" + host + ":" + port + "/" + srv;
      System.out.println("Looking-up TimeService " + url);
      TimeService ts = (TimeService)Naming.lookup(url); 
      System.out.println("  Server time is " + ts.getTime()); 
      System.out.print("  MyTimeStore contains ");
      TimeStore tsd = new MyTimeStore(); 
      tsd = ts.storeTime(tsd); 
      System.out.println(tsd.getTime());
    } catch (Exception e) {
      System.err.println(e.toString());
      System.exit(1);
    }
  }
}